/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.handler;

import fuzs.completionistsindex.CompletionistsIndex;
import fuzs.completionistsindex.client.gui.screens.inventory.IndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.inventory.ModsIndexViewScreen;
import fuzs.completionistsindex.config.ClientConfig;
import fuzs.puzzleslib.client.gui.screens.CommonScreens;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;

public class IndexButtonHandler {
    @Nullable
    private static AbstractWidget recipeBookButton;
    @Nullable
    private static AbstractWidget collectorsLogButton;

    public static void onScreenInit$Post$1(Screen screen, Minecraft minecraft, int width, int height, Consumer<AbstractWidget> addWidget) {
        if (((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class)).indexButtonScreen == ClientConfig.IndexButtonScreen.PAUSE_MENU) {
            return;
        }
        List renderables = CommonScreens.INSTANCE.getRenderableButtons(screen);
        recipeBookButton = IndexButtonHandler.findRecipeBookButton(renderables);
        if (recipeBookButton == null) {
            return;
        }
        collectorsLogButton = new ImageButton(IndexButtonHandler.recipeBookButton.f_93620_ + recipeBookButton.m_5711_() + 8, IndexButtonHandler.recipeBookButton.f_93621_, 20, 18, 100, 198, 18, IndexViewScreen.INDEX_LOCATION, 512, 256, button -> minecraft.m_91152_((Screen)new ModsIndexViewScreen(screen)));
        addWidget.accept(collectorsLogButton);
    }

    private static AbstractWidget findRecipeBookButton(List<Widget> renderables) {
        for (Widget renderable : renderables) {
            if (!(renderable instanceof ImageButton)) continue;
            ImageButton imageButton = (ImageButton)renderable;
            return imageButton;
        }
        return null;
    }

    public static void onMouseClicked$Post(Screen screen, double mouseX, double mouseY, int buttonId) {
        if (collectorsLogButton != null && recipeBookButton != null) {
            IndexButtonHandler.collectorsLogButton.f_93620_ = IndexButtonHandler.recipeBookButton.f_93620_ + recipeBookButton.m_5711_() + 8;
            IndexButtonHandler.collectorsLogButton.f_93621_ = IndexButtonHandler.recipeBookButton.f_93621_;
        }
    }

    public static void onScreenInit$Post$2(Screen screen, Minecraft minecraft, int width, int height, Consumer<AbstractWidget> addWidget) {
        String[] vanillaButtons;
        if (((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class)).indexButtonScreen == ClientConfig.IndexButtonScreen.INVENTORY_MENU) {
            return;
        }
        List renderables = CommonScreens.INSTANCE.getRenderableButtons(screen);
        int buttonX = width / 2 + 4 + 98 + 4;
        int buttonY = height / 4 + 48 + -16;
        for (String buttonKey : vanillaButtons = new String[]{"gui.stats", "menu.returnToGame", "menu.reportBugs", "menu.shareToLan"}) {
            Optional<Button> menuButton = IndexButtonHandler.getButton(renderables, buttonKey);
            if (!menuButton.isPresent()) continue;
            Button otherButton = menuButton.get();
            buttonX = otherButton.f_93620_ + otherButton.m_5711_() + 4;
            buttonY = otherButton.f_93621_;
            break;
        }
        addWidget.accept((AbstractWidget)new ImageButton(buttonX, buttonY, 20, 20, 80, 198, 20, IndexViewScreen.INDEX_LOCATION, 512, 256, button -> minecraft.m_91152_((Screen)new ModsIndexViewScreen(screen))));
    }

    private static Optional<Button> getButton(List<Widget> renderables, String translationKey) {
        for (Widget widget : renderables) {
            Button button;
            if (!(widget instanceof Button) || !IndexButtonHandler.matchesTranslationKey(button = (Button)widget, translationKey)) continue;
            return Optional.of(button);
        }
        return Optional.empty();
    }

    private static boolean matchesTranslationKey(Button button, String translationKey) {
        TranslatableContents contents;
        ComponentContents componentContents = button.m_6035_().m_214077_();
        return componentContents instanceof TranslatableContents && (contents = (TranslatableContents)componentContents).m_237508_().equals(translationKey);
    }
}

